﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Nova.Libraries;
using System.Web.Mail;
using System.Net.Mail;
using System.Net;

namespace Nova.Controllers
{
    public class HomeController : Controller
    {
        //
        // GET: /Home/

             public ActionResult Index()
             {
                 bdNovaEntities db = new bdNovaEntities();
                 if (HttpContext.User.Identity.IsAuthenticated)
                 {
                 ViewData["HtmlAlertas"] = "";
                 string nombre = HttpContext.User.Identity.Name;
                 if (HttpContext.Session["IdKardex"]== null)
                    {
                        var usuario = from a in db.AspNetUsers
                                      join b in db.UsuarioKardex on a.Id equals b.Id
                                      join c in db.Kardex_ctDatosPersonales on b.IdKardex equals c.IdKardex
                                      where a.UserName == nombre
                                      select new { IdKardex = c.IdKardex, NombreUsuario = c.Nombre + " " + c.ApellidoPaterno + " " + c.ApellidoMaterno };
                        HttpContext.Session["IdKardex"] = usuario.First().IdKardex;
                        HttpContext.Session["NombreUsuario"] = usuario.First().NombreUsuario;
                        int idk = (int)HttpContext.Session["IdKardex"];
                        var ideo = from a in db.Convenios_stConvenioLaboralTrabajadorCategoria
                                   join b in db.Convenios_stConvenioLaboralTrabajador on a.IdConvenioLaboralTrabajador equals b.IdConvenioLaboralTrabajador
                                   join c in db.Kardex_ctTrabajador on b.IdTrabajador equals c.IdKardex
                                   join d in db.Catalogos_ctEstructuraOrganica on a.IdEstructuraOrganica equals d.IdEstructuraOrganica
                                   where c.IdKardex == idk
                                   orderby a.FechaInicio descending
                                   select new { IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria, FechaInicio = a.FechaInicio, IdEstructuraOrganica = a.IdEstructuraOrganica, EstructuraOrganica = d.EstructuraOrganica };
                        if (ideo.Count() == 0)
                        {
                            throw new Exception("El usuario no es un trabajador activo, no es posible acceder a la funcionalidad");
                        }
                        HttpContext.Session["IdEstructuraOrganicaFisica"] = ideo.First().IdEstructuraOrganica;
                        HttpContext.Session["AreaUsuario"] = ideo.First().EstructuraOrganica;

                    }
                 string app = "";
                 if (Session["Aplicacion"] != null)
                     {
                     app = Session["Aplicacion"].ToString();
                     }
                     
                 if (nombre == "roberv89@gmail.com" && app == "EVENTOS")
                 {
                     //HttpContext.Session["IdEstructuraOrganicaFisica"] = (short)17;
                     //HttpContext.Session["AreaUsuario"] = "DEPARTAMENTO DE OPERACIÓN Y COORDINACIÓN";

                     var EventosSinEnterar = from a in db.SieEventos
                                             where a.FechaEnterado == null
                                             select new { };
                     if (EventosSinEnterar == null)
                     {
                         Alertas.Show(ViewData, "SieEventos", "IndexEnterar", TipoIcono.aviso, "Nada", "0", "id1");

                     }
                     else
                     {

                         Alertas.Show(ViewData, "SieEventos", "IndexEnterar", TipoIcono.aviso, "Nada", EventosSinEnterar.Count().ToString() , "id1");

                     }
                     var DocumentosSinReporte = from a in db.SieDocumentoEstructura
                                             where a.FechaReporte == null
                                             select new { };
                     if (DocumentosSinReporte == null)
                     {
                         Alertas.Show(ViewData, "SieDocumentoEstructuras", "Index", TipoIcono.descarga, "Nada", "0", "id2");

                     }
                     else
                     {

                         Alertas.Show(ViewData, "SieDocumentoEstructuras", "Index", TipoIcono.descarga, "Nada", DocumentosSinReporte.Count().ToString() , "id2");

                     }

                 }
                 if (nombre == "jcmc2@hotmail.com")
                 {
                     //HttpContext.Session["IdEstructuraOrganicaFisica"] = (short)66;
                     //HttpContext.Session["AreaUsuario"] = "EMSAD NUM. 1 COIXTLAHUACA";

                     var EventosSinAtender = from a in db.SieEventos
                                             where a.FechaAtendido == null && a.IdEstructuraOrganicaInformo == 66
                                             select new { };
                     if (EventosSinAtender == null)
                     {
                         Alertas.Show(ViewData, "SieEventos", "Index", TipoIcono.aviso, "Nada", "0", "id1");

                     }
                     else
                     {

                         Alertas.Show(ViewData, "SieEventos", "Index", TipoIcono.aviso, "Nada", EventosSinAtender.Count().ToString()  , "id1");

                     }

                 }
                 if (nombre == "pzafra@hotmail.com")
                 {
                     //HttpContext.Session["IdEstructuraOrganicaFisica"] = (short)18;
                     //HttpContext.Session["AreaUsuario"] = "DEPARTAMENTO DE LA SUPERVISIÓN DE LA GESTIÓN EDU";

                     var EventosSinEnterar = from a in db.SieEventos
                                             where a.IdEstructuraOrganicaDelegada == 18
                                             select new { };
                     if (EventosSinEnterar == null)
                     {
                         Alertas.Show(ViewData, "SieEventos", "IndexDelegar", TipoIcono.aviso, "Nada", "0", "id1");

                     }
                     else
                     {

                         Alertas.Show(ViewData, "SieEventos", "IndexDelegar", TipoIcono.aviso, "Nada", EventosSinEnterar.Count().ToString() , "id1");

                     }

                 }
                 }

                     //throw new Exception("Excepción no controlada");
                     return View();
                     // return RedirectToAction("Registro", "Home");
                     //  return View("_registro");
                 }
            
        // GET: /Error/


        public ActionResult Registro()
        {
            //throw new Exception("Excepción no controlada");
            return View("_registro");
        }

     

        

        [HttpPost]
        public ActionResult ValidarID()
        {

            bdNovaEntities db = new bdNovaEntities();
            
            Int32 idemp=  ConvertToInt.ConvertToInt32(Request["IdEmpleado"]);
            Kardex_ctDatosPersonales idtrabajador = db.Kardex_ctDatosPersonales.Where(b => b.IdeEmpleadoAnt == idemp).FirstOrDefault();
             if (idtrabajador == null)
             {
                 MessageBox.Show(ViewData, TipoMensaje.Error, "No existe ese Id en nuestra base de datos, verifique su informacion");
                 return View("_registro");
             }
             else
             {
                 idtrabajador = null;
                  idtrabajador = db.Kardex_ctDatosPersonales.Where(b => b.IdeEmpleadoAnt == idemp &&  b.ProcesoCompletado==false).FirstOrDefault();
                  if (idtrabajador == null)
                  {
                      idtrabajador = db.Kardex_ctDatosPersonales.Where(b => b.IdeEmpleadoAnt == idemp).FirstOrDefault();
                      string check = Cifrado.Encrypt(idtrabajador.CorreoElectronico + idtrabajador.IdKardex.ToString());
                      return RedirectToAction("terminado", "DatosPersonales", new { id = idtrabajador.IdKardex, email = idtrabajador.CorreoElectronico, check = check });
                  }
                  else

                      //return View("registroPaso2", new { id = idtrabajador.IdKardex });
                      ViewBag.NombreTrabajador = idtrabajador.Nombre + ' ' + idtrabajador.ApellidoPaterno + ' ' + idtrabajador.ApellidoMaterno;
                         ViewBag.id = idtrabajador.IdKardex ;
                     return View("_confirmarId");

               
             }
            
        }

        [HttpPost]
        public ActionResult RegistroPaso2(Int32 id)
        {
            //throw new Exception("Excepción no controlada");
            ViewBag.Id = id;
            return View("RegistroPaso2");
        }


        [HttpPost]
        public ActionResult EnviarEmail()
        {

            bdNovaEntities db = new bdNovaEntities();

            string email= (Request["email"]).Trim();
            string id = (Request["Id"]).Trim();


            Int16 ide = ConvertToInt.ConvertToInt16(id);

            var existe = db.Kardex_ctDatosPersonales.Where(g => g.CorreoElectronico == email && g.IdeEmpleadoAnt != ide).Select(e => e.CorreoElectronico).SingleOrDefault();
            if (existe == null)
            {
                

                ViewBag.email = email;

                System.Net.Mail.MailMessage msg = new System.Net.Mail.MailMessage();

                msg.From = new MailAddress("infonominas@cecyteo.edu.mx");
                msg.To.Add(email);
                msg.Subject = "Actualización de información laboral";
                msg.IsBodyHtml = true;
                string codificado = Cifrado.Encrypt(email + id.ToString());

                UrlHelper u = new UrlHelper(this.ControllerContext.RequestContext);

                string url = HttpContext.Request.Url.Scheme + "://" + HttpContext.Request.Url.Authority + u.Action("Edit", "DatosPersonales", new { id = id, email = email, check = HttpUtility.UrlEncode(codificado) });


                msg.Body = "<p>Estimado Trabajador</p><strong></strong><p>Para iniciar su proceso de actualización de información de datos personales y familiares de clic en la siguiente liga <a href='" + url + "'>clic aquí</a> ";

                msg.Body = msg.Body + " <p></p><p><strong>Cualquier duda o aclaración con este proceso favor de dirigirse con el Departamento de Recursos Humanos a los teléfonos : (951) 515-8036  ext. 234 de 08:00 a 16:00 horas de Lunes a Viernes.</strong></p> ";

                msg.Body = msg.Body + " <p></p><p>Este correo fue generado automáticamente, favor de no responder.</p>";


                //  msg.Priority = MailPriority.High;

                SmtpClient client = new SmtpClient();


                client.Credentials = new NetworkCredential("infonominas@cecyteo.edu.mx", "hola123@");
                client.Host = "smtp.gmail.com";
                client.Port = 587;
                client.DeliveryMethod = SmtpDeliveryMethod.Network;
                client.EnableSsl = true;
                // client.UseDefaultCredentials = false;

                try
                {
                    client.Send(msg);
                    return View("mailenviado");
                }
                catch (Exception)
                {

                    throw new Exception(" El mail no ha podido ser enviado , intente más tarde");
                }

                
            }

            else
            {
                MessageBox.Show(ViewData,TipoMensaje.Error," El correo electronico : " + email + " ya ha sido registrado por otra persona en nuestra base de datos, si considera que hay un problema con esta situación por favor comuniquese al departamento de Recursos Humanos para cualquier aclaración o duda");
            }

            return View("registropaso2");

            

        }

    }
}
